VERSION ("LCD 1.0")

'************************************************************************************************************
'
'  Sample Program for LCD Screen Commands
'
'  Target Machine : CPT-711
'
'  Commands :
'	FILL_RECT (x%, y%, size_x%, size_y%) : To fill a rectangular area.
'	CLR_RECT (x%, y%, size_x%, size_y%) : To clear a rectangle area.
'				"x% is the x coordinate of the upper left point of the rectangle area.
'				"y% is the y coordinate of the upper left point of the rectangle area.
'				"size_x% is the width of the rectangle area in pixels.
'				"size_y% is the height of the rectangle area in pixels.
'
'	CLS : To clear the LCD display.
'
'	SELECT_FONT(font%) : To select different font size for the LCD display.
'				 "font% may be 1, 2, or 3.
'					 1: font size: 6X8
'					 2: font size: 8X16
'
'	SET_VIDEO_MODE(mode%) : To set the display mode for the LCD.
'					"mode% may be 0, or 1.
'						   0: normal mode
'						   1: reverse mode
'
'************************************************************************************************************


    	CLS
	LOCATE 1,6
	PRINT "[ LCD TEST ]"

	FILL_RECT(5, 5, 10, 10)
	CLR_RECT(8, 8, 4, 4)

	SELECT_FONT(2)
	SET_VIDEO_MODE(1)

	LOCATE 4,3
	PRINT "FONT : 8*16"
	LOCATE 6,3
	PRINT "REVERSE MODE"

	SELECT_FONT(1)
	SET_VIDEO_MODE(0)

	LOCATE 7,4
	PRINT "FONT : 6*8"
	LOCATE 8,4
	PRINT "NORMAL MODE"

	LOCATE 1,4
	INPUT A$
